% Visualize th 2D Spatial distibution of each cluster

function Visualize_Cluster_Distribution(Clusters_vector,dim1,dim2,indx,k_clusters,Histology_Image,clusterMethod)

% clusterMethod = 'Kmeans';
% clusterMethod = 'dendrogram';

if ~exist(strcat('Clusters_Distributions_',clusterMethod),'dir')
    mkdir (strcat('Clusters_Distributions_',clusterMethod));
end

Folder_path = strcat('Clusters_Distributions_',clusterMethod,'\','maxclust_',num2str(k_clusters));

if ~exist(Folder_path,'dir')
    mkdir (Folder_path);
end

if (clusterMethod == 'Kmeans')
    Im_name = 'cluster_';
else
    Im_name = 'Nodes';
end
    

for i=1:k_clusters
n = dim1*dim2;
D = zeros(n,1);
D(indx) = (Clusters_vector(:)==i);
F1 = reshape(D(:),[dim1 dim2]);
% figure, imagesc(F1);
Fs = imresize(F1,10,'bilinear');
If = imfuse(Fs,Histology_Image); image(If);
saveas(gcf,strcat(Folder_path,'\',Im_name,num2str(i),'.tif'));
end
